

varying vec2 texcoord;

#ifdef DOF
const vec2 dof_offsets16[16] = vec2[16](
    vec2(0.0000, 0.5000), vec2(-0.3536, 0.3536), vec2(-0.5000, 0.0000), vec2(-0.3536, -0.3536),
    vec2(0.0000, -0.5000), vec2(0.3536, -0.3536), vec2(0.5000, 0.0000), vec2(0.3536, 0.3536),
    vec2(0.0000, 0.7500), vec2(-0.5303, 0.5303), vec2(-0.7500, 0.0000), vec2(-0.5303, -0.5303),
    vec2(0.0000, -0.7500), vec2(0.5303, -0.5303), vec2(0.7500, 0.0000), vec2(0.5303, 0.5303));

const vec2 dof_offsets60[60] = vec2[60](
    vec2(0.0000, 0.2500), vec2(-0.2165, 0.1250), vec2(-0.2165, -0.1250), vec2(-0.0000, -0.2500), vec2(0.2165, -0.1250),
    vec2(0.2165, 0.1250), vec2(0.0000, 0.5000), vec2(-0.2500, 0.4330), vec2(-0.4330, 0.2500), vec2(-0.5000, 0.0000),
    vec2(-0.4330, -0.2500), vec2(-0.2500, -0.4330), vec2(-0.0000, -0.5000), vec2(0.2500, -0.4330),
    vec2(0.4330, -0.2500), vec2(0.5000, -0.0000), vec2(0.4330, 0.2500), vec2(0.2500, 0.4330), vec2(0.0000, 0.7500),
    vec2(-0.2565, 0.7048), vec2(-0.4821, 0.5745), vec2(-0.6495, 0.3750), vec2(-0.7386, 0.1302), vec2(-0.7386, -0.1302),
    vec2(-0.6495, -0.3750), vec2(-0.4821, -0.5745), vec2(-0.2565, -0.7048), vec2(-0.0000, -0.7500),
    vec2(0.2565, -0.7048), vec2(0.4821, -0.5745), vec2(0.6495, -0.3750), vec2(0.7386, -0.1302), vec2(0.7386, 0.1302),
    vec2(0.6495, 0.3750), vec2(0.4821, 0.5745), vec2(0.2565, 0.7048), vec2(0.0000, 1.0000), vec2(-0.2588, 0.9659),
    vec2(-0.5000, 0.8660), vec2(-0.7071, 0.7071), vec2(-0.8660, 0.5000), vec2(-0.9659, 0.2588), vec2(-1.0000, 0.0000),
    vec2(-0.9659, -0.2588), vec2(-0.8660, -0.5000), vec2(-0.7071, -0.7071), vec2(-0.5000, -0.8660),
    vec2(-0.2588, -0.9659), vec2(-0.0000, -1.0000), vec2(0.2588, -0.9659), vec2(0.5000, -0.8660), vec2(0.7071, -0.7071),
    vec2(0.8660, -0.5000), vec2(0.9659, -0.2588), vec2(1.0000, -0.0000), vec2(0.9659, 0.2588), vec2(0.8660, 0.5000),
    vec2(0.7071, 0.7071), vec2(0.5000, 0.8660), vec2(0.2588, 0.9659));

const vec2 hex_offsets[60] = vec2[60](
    vec2(0.2165, 0.1250), vec2(0.0000, 0.2500), vec2(-0.2165, 0.1250), vec2(-0.2165, -0.1250), vec2(-0.0000, -0.2500),
    vec2(0.2165, -0.1250), vec2(0.4330, 0.2500), vec2(0.0000, 0.5000), vec2(-0.4330, 0.2500), vec2(-0.4330, -0.2500),
    vec2(-0.0000, -0.5000), vec2(0.4330, -0.2500), vec2(0.6495, 0.3750), vec2(0.0000, 0.7500), vec2(-0.6495, 0.3750),
    vec2(-0.6495, -0.3750), vec2(-0.0000, -0.7500), vec2(0.6495, -0.3750), vec2(0.8660, 0.5000), vec2(0.0000, 1.0000),
    vec2(-0.8660, 0.5000), vec2(-0.8660, -0.5000), vec2(-0.0000, -1.0000), vec2(0.8660, -0.5000), vec2(0.2163, 0.3754),
    vec2(-0.2170, 0.3750), vec2(-0.4333, -0.0004), vec2(-0.2163, -0.3754), vec2(0.2170, -0.3750), vec2(0.4333, 0.0004),
    vec2(0.4328, 0.5004), vec2(-0.2170, 0.6250), vec2(-0.6498, 0.1246), vec2(-0.4328, -0.5004), vec2(0.2170, -0.6250),
    vec2(0.6498, -0.1246), vec2(0.6493, 0.6254), vec2(-0.2170, 0.8750), vec2(-0.8663, 0.2496), vec2(-0.6493, -0.6254),
    vec2(0.2170, -0.8750), vec2(0.8663, -0.2496), vec2(0.2160, 0.6259), vec2(-0.4340, 0.5000), vec2(-0.6500, -0.1259),
    vec2(-0.2160, -0.6259), vec2(0.4340, -0.5000), vec2(0.6500, 0.1259), vec2(0.4325, 0.7509), vec2(-0.4340, 0.7500),
    vec2(-0.8665, -0.0009), vec2(-0.4325, -0.7509), vec2(0.4340, -0.7500), vec2(0.8665, 0.0009), vec2(0.2158, 0.8763),
    vec2(-0.6510, 0.6250), vec2(-0.8668, -0.2513), vec2(-0.2158, -0.8763), vec2(0.6510, -0.6250), vec2(0.8668, 0.2513));

const vec2 dof_offsets209[209] = vec2[209](
    vec2(0.8886414, 0.07936136), vec2(0.8190064, 0.1900164), vec2(0.8614115, -0.06991258), vec2(0.7685533, 0.03792081),
    vec2(0.9970094, 0.02585129), vec2(0.9686818, 0.1570935), vec2(0.9854341, -0.09172997), vec2(0.9330608, 0.3326486),
    vec2(0.8329557, -0.2438523), vec2(0.664771, -0.0837701), vec2(0.7429124, -0.1530652), vec2(0.9506453, -0.2174281),
    vec2(0.8192949, 0.3485171), vec2(0.6851269, 0.2711877), vec2(0.7665657, 0.5014166), vec2(0.673241, 0.3793408),
    vec2(0.6981376, 0.1465924), vec2(0.6521665, -0.2384985), vec2(0.5145761, -0.05752508), vec2(0.5641244, -0.169443),
    vec2(0.5916035, 0.06004957), vec2(0.57079, 0.234188), vec2(0.509311, 0.1523665), vec2(0.4204576, 0.05759521),
    vec2(0.8200846, -0.3601041), vec2(0.6893264, -0.3473432), vec2(0.4775535, -0.3062558), vec2(0.438106, -0.1796866),
    vec2(0.4056528, -0.08251233), vec2(0.5771964, 0.5502692), vec2(0.5094061, 0.4025192), vec2(0.6908483, 0.572951),
    vec2(0.5379036, -0.4542191), vec2(0.8167359, -0.4793735), vec2(0.6829269, -0.4557574), vec2(0.5725697, -0.3477072),
    vec2(0.5767449, -0.5782524), vec2(0.3979413, -0.4172934), vec2(0.4282598, -0.5145645), vec2(0.938814, -0.3239739),
    vec2(0.702452, -0.5662871), vec2(0.2832307, -0.1285671), vec2(0.3230537, -0.2691054), vec2(0.2921676, -0.3734582),
    vec2(0.2534037, -0.4906001), vec2(0.4343273, 0.5223463), vec2(0.3605334, 0.3151571), vec2(0.3498518, 0.451428),
    vec2(0.3230703, 0.00287089), vec2(0.1049206, -0.1476725), vec2(0.2063161, -0.2608192), vec2(0.7266634, 0.6725333),
    vec2(0.4027067, -0.6185485), vec2(0.2655533, -0.5912259), vec2(0.4947965, 0.3025357), vec2(0.5760762, 0.68844),
    vec2(0.4909205, -0.6975324), vec2(0.8609334, 0.4559), vec2(0.1836646, 0.03724086), vec2(0.2878554, 0.178938),
    vec2(0.3948484, 0.1618928), vec2(0.3519658, -0.7628763), vec2(0.6338583, -0.673193), vec2(0.5511802, -0.8283072),
    vec2(0.4090595, -0.8717521), vec2(0.1482169, -0.374728), vec2(0.1050598, -0.2613987), vec2(0.4210334, 0.6578422),
    vec2(0.2430464, 0.4383665), vec2(0.3329675, 0.5512741), vec2(0.2147711, 0.3245511), vec2(0.1227196, 0.2529026),
    vec2(-0.03937457, 0.156439), vec2(0.05618772, 0.06690486), vec2(0.06519571, 0.3974038), vec2(0.1360903, 0.1466078),
    vec2(-0.00170609, 0.3089452), vec2(0.1357622, -0.5088975), vec2(0.1604694, -0.7453476), vec2(0.1245694, -0.6337074),
    vec2(0.02542936, -0.3728781), vec2(0.02222222, -0.649554), vec2(0.09870815, 0.5357338), vec2(0.2073958, 0.5452989),
    vec2(0.216654, -0.8935689), vec2(0.2422334, 0.665805), vec2(0.0574713, 0.6742729), vec2(0.2021346, 0.8144029),
    vec2(0.3086587, 0.7504997), vec2(0.02122174, -0.7498575), vec2(-0.1551729, 0.1809731), vec2(-0.1947583, 0.06246066),
    vec2(-0.05754202, -0.03901273), vec2(-0.1083095, 0.2952235), vec2(-0.03259534, -0.492394),
    vec2(-0.02488567, -0.2081116), vec2(-0.1820729, -0.1829884), vec2(-0.1674413, -0.04529009),
    vec2(0.04342153, -0.0368562), vec2(0.801399, -0.5845526), vec2(0.3158276, -0.9124843), vec2(-0.05945269, 0.6727523),
    vec2(0.07701834, 0.8579889), vec2(-0.05778154, 0.5699022), vec2(0.1191713, 0.7542591), vec2(-0.2578296, 0.3630984),
    vec2(-0.1428598, 0.4557526), vec2(-0.3304029, 0.5055485), vec2(-0.3227198, 0.1847367), vec2(-0.4183801, 0.3412776),
    vec2(0.2538475, 0.9317476), vec2(0.406249, 0.8423664), vec2(0.4718862, 0.7592828), vec2(0.168472, -0.06605823),
    vec2(0.2632498, -0.7084918), vec2(-0.2816192, -0.1023492), vec2(-0.3161443, 0.02489911),
    vec2(-0.4677814, 0.08450397), vec2(-0.4156994, 0.2408664), vec2(-0.237449, 0.2605326), vec2(-0.0912179, 0.06491816),
    vec2(0.01475127, 0.7670643), vec2(0.1216858, -0.9368939), vec2(0.07010741, -0.841011), vec2(-0.1708607, -0.4152923),
    vec2(-0.1345006, -0.5842513), vec2(-0.09419055, -0.3213732), vec2(-0.2149337, 0.730642),
    vec2(-0.1102187, 0.8425013), vec2(-0.1808572, 0.6244397), vec2(-0.2414505, -0.7063725), vec2(-0.2410318, -0.537854),
    vec2(-0.1005938, -0.7635075), vec2(0.1053517, 0.9678772), vec2(-0.3340288, 0.6926677), vec2(-0.2363931, 0.8464488),
    vec2(-0.4057773, 0.7786722), vec2(-0.5484858, 0.1686208), vec2(-0.64842, 0.02256887), vec2(-0.5544513, -0.02348978),
    vec2(-0.492855, -0.1083694), vec2(-0.4248196, 0.4674786), vec2(-0.5873146, 0.4072608), vec2(-0.6439911, 0.3038489),
    vec2(-0.6419188, 0.1293737), vec2(-0.005880734, 0.4699725), vec2(-0.4239455, 0.6250131),
    vec2(-0.1701273, 0.9506347), vec2(7.665656E-05, 0.9941212), vec2(-0.7070159, 0.4426281),
    vec2(-0.7481344, 0.3139496), vec2(-0.8330062, 0.2472693), vec2(-0.7271438, 0.2024286), vec2(-0.5179888, 0.3149576),
    vec2(-0.8258062, 0.3779382), vec2(-0.8063191, 0.1262931), vec2(-0.2690676, -0.4360798),
    vec2(-0.3714577, -0.5887412), vec2(-0.3736085, -0.4018324), vec2(-0.3228985, -0.2063406),
    vec2(-0.2414576, -0.2875458), vec2(-0.4720859, -0.3823904), vec2(-0.4937642, -0.2686005),
    vec2(-0.01500604, -0.9587054), vec2(-0.08535925, -0.8820614), vec2(-0.6436375, -0.3157263),
    vec2(-0.5736347, -0.4224878), vec2(-0.5026127, -0.5516239), vec2(-0.8200902, 0.5370023), vec2(-0.7196413, 0.57133),
    vec2(-0.5849072, 0.5917885), vec2(-0.1598758, -0.9739854), vec2(-0.4230629, -0.01858409),
    vec2(-0.9403627, 0.2213769), vec2(-0.685889, -0.2192711), vec2(-0.6693704, -0.4884708),
    vec2(-0.7967147, -0.3078234), vec2(-0.596441, -0.1686891), vec2(-0.7366468, -0.3939891),
    vec2(-0.7963406, 0.02246814), vec2(-0.9177913, 0.0929693), vec2(-0.9284672, 0.3329005), vec2(-0.6497722, 0.6851863),
    vec2(-0.496019, 0.7013303), vec2(-0.3930301, -0.6892192), vec2(-0.2122009, -0.8777389), vec2(-0.3660335, -0.801644),
    vec2(-0.386839, -0.1191898), vec2(-0.7020127, -0.0776734), vec2(-0.7760845, -0.1566844),
    vec2(-0.5444778, -0.6516482), vec2(-0.5331346, 0.4946506), vec2(-0.3288236, 0.9408244), vec2(0.5819826, 0.8101937),
    vec2(-0.4894184, -0.8290837), vec2(-0.5183194, 0.8454953), vec2(-0.7665774, -0.5223897),
    vec2(-0.6703191, -0.6217513), vec2(-0.8902924, -0.2446688), vec2(-0.8574848, -0.09174173),
    vec2(-0.3544409, -0.9239591), vec2(-0.969833, -0.1172272), vec2(-0.8968207, -0.4079512),
    vec2(-0.5891477, 0.7724466), vec2(-0.2146262, 0.5286855), vec2(-0.3762444, -0.3014335),
    vec2(-0.9466863, -0.008970681), vec2(-0.596356, -0.7976127), vec2(-0.8877738, 0.4569088));
const vec2 poisson9[9] =
    vec2[9](vec2(0.0, 0.0), vec2(-0.9593429276184573, 0.2741059897004429), vec2(0.3343931572216966, 0.9400977975034214),
            vec2(0.5161231138968027, -0.8359942666643262), vec2(-0.6358634003266569, -0.7696753168276977),
            vec2(0.8455631130604443, 0.29639088658129153), vec2(-0.33086582764585326, 0.8007864879607953),
            vec2(0.7979385512418102, -0.3075891791175882), vec2(-0.054614199585027716, -0.9176900083643398));

const vec2 paint_offsets[6] = vec2[6](vec2(1, 0), vec2(0.5, 0.86602540378), vec2(-0.5, 0.86602540378), vec2(-1, 0),
                                      vec2(-0.5, -0.86602540378), vec2(0.5, -0.86602540378));

#endif


float calculateFocus()
{
#if DOF_MODE == 0
    return centerDepthSmooth;
#elif DOF_MODE == 1
    return MANUAL_FOCUS;
#elif DOF_MODE == 2
    return MANUAL_FOCUS * screenBrightness;
#else
    return 1.0;
#endif
}
vec3 Bokeh(sampler2D tex, vec2 uv, float radius)
{
    const float GOLDEN_ANGLE = 2.3999632;

#define ITERATIONS 150

    const mat2 rot = mat2(cos(GOLDEN_ANGLE), sin(GOLDEN_ANGLE), -sin(GOLDEN_ANGLE), cos(GOLDEN_ANGLE));

    vec3 acc = vec3(0), div = acc;
    float r = 1.;
    vec2 vangle = vec2(0.0, radius * .01 / sqrt(float(ITERATIONS)));

    for (int j = 0; j < ITERATIONS; j++)
    {
        // the approx increase in the scale of sqrt(0, 1, 2, 3...)
        r += 1. / r;
        vangle = rot * vangle;
        vec3 col = texture(tex, uv + (r - 1.) * vangle).xyz; /// ... Sample the image
        col = col * col * 1.8;                               // ... Contrast it for better highlights - leave this out elsewhere.
        vec3 bokeh = pow(col, vec3(4));
        acc += col * bokeh;
        div += bokeh;
    }
    return acc / div;
}

vec2 calculatePcoc(float focus)
{

    // Convert sensor size from mm to meters
    const float sensorHeight = CAMERA_SENSOR_SIZE_MM * 1e-3;
    float sensorWidth = sensorHeight;
    vec2 sensorSize = aspectRatio * vec2(sensorWidth, sensorHeight);

    // Convert focal length to meters
    const float focalLength = FOCAL * 1e-3;

    // Calculate aperture diameter and radius
    const float apertureDiameter = focalLength / APERTURE;
    const float apertureRadius = apertureDiameter * 0.5;
    float sampleScale = 0.016;

    // Initialize CoC accumulator
    vec2 pcoc = vec2(0.0);

    // Number of samples
    const int sampleCount = 16;
    float x = (gbufferProjection[1][1] / sensorSize.x);
    float y = aspectRatio * (gbufferProjection[1][1] / sensorSize.y);
#ifdef TILT_SHIFT
    // Tilt-shift parameters
    float tiltAngle = radians(TILT_ANGLE);    // Tilt angle in degrees (default 5°, set to 0° for no tilt)
    float shiftAmount = SHIFT_AMOUNT * 0.002; // Shift amount (0 means no shift)
    vec2 shiftDirection = vec2(0.0, 1.0);     // Direction of shift (default vertical)
#endif
    for (int i = 0; i < sampleCount; i++)
    {

        vec2 offset = vec2(dof_offsets16[i].x * sampleScale / aspectRatio, dof_offsets16[i].y * sampleScale);

        float depth = texture(depthtex1, texcoord - offset).x;
        float adjustedFocusDistance = focus;
#ifdef TILT_SHIFT
        // Calculate tilt effect by adjusting focus distance based on tilt angle
        float tiltOffset = tan(tiltAngle * 8.0) * (texcoord.y - 0.5) * sensorHeight;
        adjustedFocusDistance += tiltOffset;

        // Apply shift effect to the focus distance
        float shiftOffset = dot(shiftDirection, vec2(texcoord - 0.5)) * shiftAmount;
        adjustedFocusDistance += shiftOffset;
#endif
        float denominator = depth * abs(adjustedFocusDistance - focalLength);
        denominator = max(denominator, 0.0001);

        float coc = (apertureRadius * abs(depth - adjustedFocusDistance)) / denominator;

        float cocX = coc * x;
        float cocY = coc * y;
        vec2 cocScreenSpace = vec2(cocX, cocY);

        pcoc += vec2(
            min(cocScreenSpace.x, texelSize.x * 256.0),
            min(cocScreenSpace.y, texelSize.y * 256.0));
    }

    // Average the accumulated CoC
    pcoc /= float(sampleCount);

#if EXCLUDE_MODE == 2
    float depth2 = texture(depthtex1, texcoord).x;
    pcoc *= float(depth2 > 0.56);
#elif EXCLUDE_MODE == 1
    float depth2 = texture(depthtex1, texcoord).x;
    pcoc *= float(depth2 > focus);
#endif

    return pcoc;
}

void main()
{
/* DRAWBUFFERS:0*/
#ifdef TAA
    vec3 color = texture(colortex4, texcoord.xy).rgb;
#else
    vec3 color = texture(colortex0, texcoord.xy).rgb;
#endif

#ifdef DOF

    // Define focus based on DOF_MODE
    float focus = calculateFocus(); // Initialize focus

    float steps = 0;

    // Define dof_offsets based on BOKEH_MODE

    #if BOKEH_MODE == 0
    steps = 60;
    vec2 dof_offsets[60] = dof_offsets60;
    #elif BOKEH_MODE == 1
    steps = 60;
    vec2 dof_offsets[60] = hex_offsets;
    #elif BOKEH_MODE == 2
    steps = 209;
    vec2 dof_offsets[209] = dof_offsets209;
    #elif BOKEH_MODE == 3
    steps = 6;
    vec2 dof_offsets[6] = paint_offsets;
    #elif BOKEH_MODE == 4
    steps = 209;
    vec2 dof_offsets[209] = dof_offsets209;
    #endif
    // float pcoc = min(abs(aperture * (focal / 100.0 * (z - focus)) / (z * (focus - focal / 100.0))), texelSize.x
    // * 15.0);

    vec2 pcoc = calculatePcoc(focus); // Implement this function based on your needs

    vec3 bcolor = vec3(0.0);

    // Calculate bcolor based on BOKEH_MODE
    #if BOKEH_MODE < 3

    for (int i = 0; i < steps; i++)
    {
        vec2 offset = dof_offsets[i] * pcoc;
        vec2 diffractionFactor = 0.1 * pcoc;

        float r = texture(colortex4, texcoord.xy + offset + diffractionFactor * vec2(1.0, 0.0)).r;
        float g = texture(colortex4, texcoord.xy + offset).g;
        float b = texture(colortex4, texcoord.xy + offset - diffractionFactor * vec2(1.0, 0.0)).b;

        bcolor += vec3(r, g, b);
    }

    color = bcolor / steps;

    #else

        #if BOKEH_MODE < 4
    vec2 d = pcoc;
    for (int i = 0; i < 6; ++i)
    {
        bcolor = texture(colortex4, texcoord.xy + paint_offsets[i] * d).rgb;
        vec3 t = max(sign(bcolor - color), 0.0);
        color += (bcolor - color) * t;
    }
    bcolor = color;

        #else

    // Parameters
    float focusPosition = 0.52;
    float focusSize = 2.0;
    float maxBlur = 30.0;
    float dist = abs(texcoord.y - focusPosition);
    float blurAmount = smoothstep(0.0, focusSize, dist) * maxBlur;

    // Accumulate blurred color
    for (int i = 0; i < steps; i++)
    {
        bcolor += texture(colortex4, texcoord.xy + dof_offsets[i] * blurAmount * pcoc).rgb;
    }
    color = bcolor / steps;

        #endif

    #endif
#endif

    gl_FragData[0].rgb = color;
}
